/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.simibubi.create.foundation.config.ConfigBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Unmodifiable;

public abstract class CentralKitchenConfigBase
extends ConfigBase {
    private final List<ConfigReloadListener> reloadListeners = new ArrayList<ConfigReloadListener>();
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    protected void registerAll(ForgeConfigSpec.Builder builder) {
        super.registerAll(builder);
    }

    public void onLoad() {
        super.onLoad();
        this.reloadListeners.forEach(ConfigReloadListener::onLoad);
    }

    public void onReload() {
        super.onReload();
        this.reloadListeners.forEach(ConfigReloadListener::onReload);
    }

    protected static boolean isValidResourceLocation(Object value) {
        String string;
        return value instanceof String && ResourceLocation.m_135830_((String)(string = (String)value));
    }

    protected static <V extends IForgeRegistryEntry<V>> List<RegistryObject<V>> createRegistryObjects(IForgeRegistry<V> registry, List<ResourceLocation> idList) {
        return idList.stream().map(id -> RegistryObject.create((ResourceLocation)id, (IForgeRegistry)registry)).toList();
    }

    protected ConfigList<Integer> intList(Supplier<List<? extends Integer>> supplier, String name, String ... comments) {
        return new ConfigList(name, supplier, value -> value instanceof Integer, comments);
    }

    protected ConfigList<Integer> intList(List<Integer> def, String name, String ... comments) {
        return new ConfigList<Integer>(name, def, value -> value instanceof Integer, comments);
    }

    protected ConfigList<Double> doubleList(Supplier<List<? extends Double>> supplier, String name, String ... comments) {
        return new ConfigList(name, supplier, value -> value instanceof Double, comments);
    }

    protected ConfigList<Double> doubleList(List<Double> def, String name, String ... comments) {
        return new ConfigList<Double>(name, def, value -> value instanceof Double, comments);
    }

    protected <E extends Enum<E>> ConfigList<Enum<E>> enumList(Class<E> clazz, List<E> current, String name, String ... comments) {
        return new ConfigList<Enum<E>>(name, current, clazz::isInstance, comments);
    }

    protected ConfigList<String> stringList(Supplier<List<? extends String>> supplier, String name, Predicate<Object> validator, String ... comments) {
        return new ConfigList(name, supplier, validator, comments);
    }

    protected ConfigList<String> stringList(Supplier<List<? extends String>> supplier, String name, String ... comments) {
        return new ConfigList(name, supplier, value -> value instanceof String, comments);
    }

    protected ConfigList<String> stringList(List<String> current, String name, Predicate<Object> validator, String ... comments) {
        return new ConfigList<String>(name, current, validator, comments);
    }

    protected ConfigList<String> stringList(List<String> current, String name, String ... comments) {
        return new ConfigList<String>(name, current, value -> value instanceof String, comments);
    }

    protected ConfigList<String> stringListAllowDefaultsOnly(List<String> current, String name, String ... comments) {
        return new ConfigList<String>(name, current, value -> {
            String string;
            return value instanceof String && current.contains(string = (String)value);
        }, comments);
    }

    protected ConfigIdList idList(Supplier<List<ResourceLocation>> supplier, Predicate<Object> validator, String name, String ... comments) {
        return new ConfigIdList(name, supplier, validator, comments);
    }

    protected ConfigIdList idList(Supplier<List<ResourceLocation>> supplier, String name, String ... comments) {
        return new ConfigIdList(name, supplier, comments);
    }

    protected ConfigIdList idList(List<ResourceLocation> current, String name, Predicate<Object> validator, String ... comments) {
        return new ConfigIdList(name, current, validator, comments);
    }

    protected ConfigIdList idList(List<ResourceLocation> current, String name, String ... comments) {
        return new ConfigIdList(name, current, comments);
    }

    protected ConfigIdList idListAllowDefaultsOnly(List<ResourceLocation> current, String name, String ... comments) {
        return new ConfigIdList(name, current, value -> CentralKitchenConfigBase.isValidResourceLocation(value) && current.contains(new ResourceLocation(value.toString())), comments);
    }

    private static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    public class ConfigList<T>
    extends ConfigBase.CValue<List<? extends T>, ForgeConfigSpec.ConfigValue<List<? extends T>>> {
        public ConfigList(String name, Supplier<List<? extends T>> supplier, Predicate<Object> validator, String ... comments) {
            super((ConfigBase)CentralKitchenConfigBase.this, name, builder -> builder.defineListAllowEmpty(CentralKitchenConfigBase.split(name), supplier, validator), comments);
        }

        public ConfigList(String name, List<? extends T> def, Predicate<Object> validator, String ... comments) {
            super((ConfigBase)CentralKitchenConfigBase.this, name, builder -> builder.defineListAllowEmpty(CentralKitchenConfigBase.split(name), () -> def, validator), comments);
        }
    }

    public class ConfigIdList
    extends ConfigList<String>
    implements ConfigReloadListener {
        private List<ResourceLocation> idList;

        public ConfigIdList(String name, Supplier<List<ResourceLocation>> supplier, Predicate<Object> validator, String ... comments) {
            super(name, () -> ((List)supplier.get()).stream().map(Object::toString).toList(), validator, comments);
            this.idList = List.of();
            CentralKitchenConfigBase.this.reloadListeners.add(this);
        }

        public ConfigIdList(String name, Supplier<List<ResourceLocation>> supplier, String ... comments) {
            this(name, supplier, CentralKitchenConfigBase::isValidResourceLocation, comments);
        }

        public ConfigIdList(String name, List<ResourceLocation> def, Predicate<Object> validator, String ... comments) {
            super(name, def.stream().map(Object::toString).toList(), CentralKitchenConfigBase::isValidResourceLocation, comments);
            this.idList = def;
            CentralKitchenConfigBase.this.reloadListeners.add(this);
        }

        public ConfigIdList(String name, List<ResourceLocation> def, String ... comments) {
            this(name, (List<ResourceLocation>)ImmutableList.copyOf(def), CentralKitchenConfigBase::isValidResourceLocation, comments);
        }

        private void updateIdList(List<? extends String> list) {
            this.idList = list.stream().filter(CentralKitchenConfigBase::isValidResourceLocation).map(ResourceLocation::new).toList();
        }

        public @Unmodifiable List<ResourceLocation> getIdList() {
            return this.idList;
        }

        public List<ResourceLocation> copyIdList() {
            return new ArrayList<ResourceLocation>(this.idList);
        }

        public void setIdList(List<ResourceLocation> idList) {
            this.idList = ImmutableList.copyOf(idList);
            this.set(this.idList.stream().map(Objects::toString).toList());
        }

        public void set(List<? extends String> value) {
            super.set(value);
            this.updateIdList(value);
        }

        @Override
        public void onReload() {
            this.updateIdList((List)this.get());
        }
    }

    public class ConfigRegistryObjectList<V extends IForgeRegistryEntry<V>>
    extends ConfigList<String>
    implements ConfigReloadListener {
        private static final Map<IForgeRegistry<?>, Predicate<Object>> VALIDATORS = new ConcurrentHashMap();
        private final IForgeRegistry<V> registry;
        private List<RegistryObject<V>> objects;

        public ConfigRegistryObjectList(String name, IForgeRegistry<V> registry, List<RegistryObject<V>> def, Predicate<Object> validator, String ... comments) {
            super(name, def.stream().map(entry -> entry.getId().toString()).toList(), validator, comments);
            this.registry = registry;
            this.setObjects(def);
            CentralKitchenConfigBase.this.reloadListeners.add(this);
        }

        public ConfigRegistryObjectList(String name, IForgeRegistry<V> registry, List<RegistryObject<V>> def, String ... comments) {
            this(name, registry, def, ConfigRegistryObjectList.validator(registry), comments);
        }

        private static Predicate<Object> validator(IForgeRegistry<?> registry) {
            return VALIDATORS.computeIfAbsent(registry, reg -> value -> {
                if (!(value instanceof String)) {
                    return false;
                }
                String string = (String)value;
                if (!ResourceLocation.m_135830_((String)string)) {
                    return false;
                }
                if (reg instanceof IForgeRegistryModifiable && ((IForgeRegistryModifiable)reg).isLocked()) {
                    ResourceLocation id = new ResourceLocation(string);
                    return reg.containsKey(id);
                }
                return true;
            });
        }

        private void updateObjects(List<? extends String> list) {
            this.objects = CentralKitchenConfigBase.createRegistryObjects(this.registry, list.stream().filter(CentralKitchenConfigBase::isValidResourceLocation).map(ResourceLocation::new).toList());
        }

        public boolean contains(V value) {
            for (RegistryObject<V> object : this.objects) {
                if (!object.isPresent() || !((IForgeRegistryEntry)object.get()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<RegistryObject<V>> getObjects(boolean existing) {
            return existing ? this.objects.stream().filter(RegistryObject::isPresent).toList() : this.objects;
        }

        public void setObjects(List<RegistryObject<V>> objects) {
            this.objects = ImmutableList.copyOf(objects);
        }

        public void set(List<? extends String> value) {
            super.set(value);
            this.updateObjects(value);
        }

        @Override
        public void onLoad() {
        }

        @Override
        public void onReload() {
            this.updateObjects((List)this.get());
        }
    }

    protected static interface ConfigReloadListener {
        default public void onLoad() {
            this.onReload();
        }

        public void onReload();
    }
}

